/******************************************************************************
 * SIENA: Simulation Investigation for Empirical Network Analysis
 *
 * Web: http://www.stats.ox.ac.uk/~snijders/siena/
 *
 * File: AllEffects.h
 *
 * Description: This is a helper file that includes the declarations of all
 * effects. It can be conveniently included in files requiring all effects.
 *****************************************************************************/

#ifndef ALLEFFECTS_H_
#define ALLEFFECTS_H_

#include "AllSimilarityEffect.h"
#include "AlterCovariateActivityEffect.h"
#include "AltersCovariateAvAltEffect.h"
#include "AltersCovariateAverageEffect.h"
#include "AltersCovariateAvSimEffect.h"
#include "AltersCovariateMinimumEffect.h"
#include "AltersCovariateMaximumEffect.h"
#include "AltersCovariateTotSimEffect.h"
#include "AltersDist2CovariateAverageEffect.h"
#include "AltersInDist2CovariateAverageEffect.h"
#include "AntiIsolateEffect.h"
#include "AverageAlterEffect.h"
#include "AverageAlterCcEffect.h"
#include "AverageAlterContinuousEffect.h"
#include "AverageAlterDist2Effect.h"
#include "AverageAlterInDist2Effect.h"
#include "AverageDegreeEffect.h"
#include "AverageGroupEffect.h"
#include "AverageGroupEgoEffect.h"
#include "AverageInAlterEffect.h"
#include "AverageReciprocatedAlterEffect.h"
#include "AverageSimilarityInDist2Effect.h"
#include "BalanceEffect.h"
#include "BehaviorInteractionEffect.h"
#include "BetweennessEffect.h"
#include "BothDegreesEffect.h"
#include "CatCovariateActivityEffect.h"
#include "ConstantEffect.h"
#include "ContinuousInteractionEffect.h"
#include "CovariateAlterEffect.h"
#include "CovariateContrastEffect.h"
#include "CovariateDiffEffect.h"
#include "CovariateDiffEgoEffect.h"
#include "CovariateEgoAlterEffect.h"
#include "CovariateEgoEffect.h"
#include "CovariateEgoSquaredEffect.h"
#include "CovariateEgoDiffEffect.h"
#include "CovariateIndirectTiesEffect.h"
#include "CovariateSimilarityEffect.h"
#include "CovariateTransitiveTripletsEffect.h"
#include "CrossCovariateActivityEffect.h"
#include "DenseTriadsBehaviorEffect.h"
#include "DenseTriadsEffect.h"
#include "DenseTriadsSimilarityEffect.h"
#include "DensityEffect.h"
#include "DistanceTwoEffect.h"
#include "DoubleDegreeBehaviorEffect.h"
#include "DoubleInPopEffect.h"
#include "DoubleRecDegreeBehaviorEffect.h"
#include "DyadicCovariateAvAltEffect.h"
#include "DyadicCovariateMainEffect.h"
#include "DyadicCovariateReciprocityEffect.h"
#include "FeedbackEffect.h"
#include "FourCyclesEffect.h"
#include "HigherCovariateEffect.h"
#include "HomCovariateActivityEffect.h"
#include "GwdspEffect.h"
#include "IndegreeEffect.h"
#include "IndegreeActivityEffect.h"
#include "IndegreeContinuousEffect.h"
#include "IndegreePopularityEffect.h"
#include "InAltersCovariateAverageEffect.h"
#include "InInDegreeAssortativityEffect.h"
#include "InIsolateDegreeEffect.h"
#include "InOutDegreeAssortativityEffect.h"
#include "InStructuralEquivalenceEffect.h"
#include "InteractionCovariateEffect.h"
#include "InterceptEffect.h"
#include "InverseOutdegreeEffect.h"
#include "InverseSquaredOutdegreeEffect.h"
#include "IsolateEffect.h"
#include "IsolateNetEffect.h"
#include "IsolateOutContinuousEffect.h"
#include "IsolatePopEffect.h"
#include "JumpCovariateTransitiveTripletsEffect.h"
#include "LinearShapeEffect.h"
#include "MainCovariateEffect.h"
#include "MainCovariateContinuousEffect.h"
#include "MaxAlterEffect.h"
#include "MaxAlterContinuousEffect.h"
#include "MixedOnlyTwoPathEffect.h"
#include "NetworkInteractionEffect.h"
#include "OutdegreeEffect.h"
#include "OutdegreeContinuousEffect.h"
#include "OutdegreeActivityEffect.h"
#include "OutdegreeActivitySqrtEffect.h"
#include "OutdegreePopularityEffect.h"
#include "OutInDegreeAssortativityEffect.h"
#include "OutIndegreeBalanceContinuousEffect.h"
#include "OutOutDegreeAssortativityEffect.h"
#include "PopularityAlterEffect.h"
#include "PrimarySettingEffect.h"  
#include "PrimaryCompressionEffect.h" 
#include "QuadraticShapeEffect.h"
#include "QuadraticShapeCcEffect.h"
#include "RecipdegreeActivityEffect.h"
#include "RecipdegreePopularityEffect.h"
#include "ReciprocalDegreeBehaviorEffect.h"
#include "ReciprocalDegreeContinuousEffect.h"
#include "ReciprocatedSimilarityEffect.h"
#include "ReciprocityEffect.h"
#include "SameCovariateEffect.h"
#include "SameCovariateActivityEffect.h"
#include "SameCovariateFourCyclesEffect.h"
#include "SameInCovariateFourCyclesEffect.h"
#include "SettingSizeEffect.h"
#include "SameCovariateTransitiveTripletsEffect.h"
#include "HomCovariateTransitiveTripletsEffect.h"
#include "SameCovariateTransitiveReciprocatedTripletsEffect.h"
#include "SimilarityEffect.h"
#include "SimilarityIndegreeEffect.h"
#include "SimilarityWEffect.h"
#include "SimilarityTransitiveTripletsEffect.h"
#include "ThreeCyclesEffect.h"
#include "ThresholdShapeEffect.h"
#include "TransitiveMediatedTripletsEffect.h"
#include "TransitiveReciprocatedTripletsEffect.h"
#include "TransitiveReciprocatedTriplets2Effect.h"
#include "TransitiveTiesEffect.h"
#include "TransitiveTriadsEffect.h"
#include "TransitiveTripletsEffect.h"
#include "TruncatedOutdegreeEffect.h"
#include "TruncatedOutXEffect.h"
#include "VarianceAlterEffect.h"
#include "VarianceAlterSimilarityEffect.h"
#include "WienerEffect.h"
#include "WWXClosureEffect.h"
#include "WXXClosureEffect.h"
#include "XWXClosureEffect.h"
#include "XXWClosureEffect.h"
#include "AgreementTransitivityGMMEffect.h"
#include "RealTransitivityGMMEffect.h"
#include "ReciprocityGMMEffect.h"
#endif /*ALLEFFECTS_H_*/
